package user_interface;
import db_context.MyExceptions;
import row_data_gateway.*;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.sql.SQLException;

public class MenuItem extends Menu {
    @Override
    public void print() {
        System.out.println("**********************************");
        System.out.println("* 1. list all items              *");
        System.out.println("* 2. create item                 *");
        System.out.println("* 3. delete item                 *");
        System.out.println("* 4. back to main menu           *");
        System.out.println("**********************************");
    }

    @Override
    public void handle(String option) {
        try {
            switch (option) {
                case "1":   listAllItems(0); break;
                case "2":   createItem(); break;
                case "3":   deleteItem(); break;
                case "4":   exit(); break;
                default:    System.out.println("Unknown option"); break;
            }
        } catch(Exception e) {
            //throw new RuntimeException(e);
            if(e.getClass().toString().equals("class java.lang.NumberFormatException")) System.out.println("Wrong input");
            else System.out.println("something went wrong\nmessage: " + e.getMessage());
        }
    }

    private void listAllItems(int offset) throws Exception {
        System.out.println("..id..|....name....|....weight....|....price....|.uninsured ratio.|..package id..");
        for (Item item : ItemsFinder.getInstance().findAll(offset)) {
            item.print(item);
        }
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        System.out.println("Show more (y)");
        if(br.readLine().equals("y")){
            listAllItems(offset + 1);
        }
    }

    private void createItem() throws Exception {
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        Item item = new Item();

        System.out.println("Enter item name:");
        item.setName(br.readLine());

        System.out.println("Enter weight:");
        item.setWeight(new BigDecimal(br.readLine()));
        System.out.println("Enter price:");
        item.setPrice(new BigDecimal(br.readLine()));
        System.out.println("Enter uninsured ratio:");
        int var = Integer.parseInt(br.readLine());
        if(var < 0 || var > 100) throw new MyExceptions.LogicException("value must be in range <0,100>");
        item.setUninsured_ratio(var);

        br.readLine();
        item.insert();

        System.out.println("The item has been added");
        System.out.print("The item's id is: " + item.getId());
    }

    private void deleteItem() throws Exception {
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        System.out.println("Enter a item id:");

        Item item = ItemsFinder.getInstance().findById(Integer.parseInt(br.readLine()));
        item.delete();
        System.out.println("The item has been successfully deleted");
    }
}
